/***************************************************************/
//
//
//		DirectX	[player.cpp]
//
//												Author	kazuki tanaka
//												Date	2016 05/30
/*---------------------------------------------------------------
Update : 2016/04/18
			bZ[W{bNX\
Update : 2016/04/25

Update : 2016/06/06
			_obt@[̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/
#include "main.h"
#include "player.h"
#include "formula.h"
#include "input.h"
#include "config.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/
/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/
#define PLAYER_TEXTURENAME "data/TEXTURE/runningman102.png"

#define PLAYER_POS_X (300)						//|S̕\ʒuX
#define PLAYER_POS_Y ( 0 )						//|S̕\ʒuY
#define PLAYER_WIDTH (440)						//|S̕
#define PLAYER_HEIGHT (100)						//|S̍

#define PLAYER_RADIUS_X ( 50 )					//jO}̒S̔aX
#define PLAYER_RADIUS_Y ( 70 )					//jO}̒S̔aY

#define PLAYER_TEXTURE_U_SIZE (0.2f)
#define PLAYER_TEXTURE_V_SIZE (0.5f)

#define PLAYER_LEFT ( 0 )
#define PLAYER_RIGHT ( 1 )

/*---------------------------------------------------------------
	\
---------------------------------------------------------------*/

// player\
typedef struct{

	float playerTexU;
	float playerTexV;

	float playerTexMoveX;
	float playerTexMoveY;

	float playerTexX;
	float playerTexY;
	float playerTexX2;
	float playerTexY2;

	float playerTexX3;
	float playerTexY3;
	float playerTexX4;
	float playerTexY4;

	VECTOR_2D vec;

	unsigned int playerFrame;
	//unsigned float playerFrame;

}PLAYER;

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/
HRESULT MakeVertexPlayer(LPDIRECT3DDEVICE9 pDevice);
												//_̍쐬
void ColorPlayer ( VERTEX_2D *pVtx );			//_̐FύX

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTexturePlayer = nullptr;	//eNX`-C^[tF-Xp

LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferplayer = nullptr;
												//_obt@C^[tF[Xւ̃|C^
PLAYER g_player;								//player
int playerVec = 0 ;								//playeřĂ

int arc = 0;									//pxplayer

// playeȑ
void InitPlayer( void )
{


	LPDIRECT3DDEVICE9 pDevice=nullptr;			//foCX󂯎p֐

	// foCX̎󂯎
	pDevice = GetDevice( );

	// W̐ݒ
	g_player.vec.sy = PLAYER_HEIGHT;

	// VERTEX_2D̐ݒ
	MakeVertexPlayer(pDevice);

	// eNX`̓ǂݍ
	if(FAILED(D3DXCreateTextureFromFile(pDevice,PLAYER_TEXTURENAME,&g_pTexturePlayer)))
	{
		MessageBox(NULL,"eNX`̃t@C̓ǂݍ݂Ɏs܂","s", MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2);
	}

}
// playeȑI
void UninitPlayer( void ){

	// eNX`C^[tF[X̊J
	SAFE_RELEASE(g_pTexturePlayer)

	// _obt@C^[tF[X̊J
	SAFE_RELEASE(g_pVtxBufferplayer)

}
// player̍XV
void UpdatePlayer( void ){

	VERTEX_2D *pVtx;							//zAhX
	bool config;								//菈

	// UVlvZ
	g_player.playerTexU = (float)( ( g_player.playerFrame ) % 5 ) * PLAYER_TEXTURE_U_SIZE;
	g_player.playerTexV = (float)( (g_player.playerFrame/5) % 2 ) * PLAYER_TEXTURE_V_SIZE;
	
	config = objectConfig( );

	if( config == false ){
		g_player.vec.sy += 1.0f * 9.8f;
	}

	//keylǂݏo
	bool inputW = GetKeyboardTrigger(DIK_W);
	if(inputW == true){
		//MessageBox(NULL,"{^ꂽ","W",MB_OK);
		g_player.vec.sy-=30.0f;
	}

	bool inputA = GetKeyboardPress(DIK_A);
	if(inputA == true){
		//MessageBox(NULL,"{^ꂽ","A",MB_OK);
		g_player.vec.sx-=10.0f;
		playerVec = PLAYER_LEFT;				//
	}

	bool inputS = GetKeyboardPress(DIK_S);
	if(inputS == true){
		//MessageBox(NULL,"{^ꂽ","S",MB_OK);
		g_player.vec.sy+=5.0f;
	}

	bool inputD = GetKeyboardPress(DIK_D);
	if(inputD == true){
		//MessageBox(NULL,"{^ꂽ","D",MB_OK);
		g_player.vec.sx+=10.0f;
		playerVec = PLAYER_RIGHT;				//E
	}

	// obt@bNzAhX擾
	g_pVtxBufferplayer -> Lock(0,0,(void**)&pVtx,0);		//GPUVRAMւ̑bN

	// UVAj[V
	if( playerVec == PLAYER_LEFT ){

		pVtx[0].tex=D3DXVECTOR2( g_player.playerTexU, g_player.playerTexV );
		pVtx[1].tex=D3DXVECTOR2( PLAYER_TEXTURE_U_SIZE+g_player.playerTexU, g_player.playerTexV );
		pVtx[2].tex=D3DXVECTOR2( g_player.playerTexU, PLAYER_TEXTURE_V_SIZE+g_player.playerTexV );
		pVtx[3].tex=D3DXVECTOR2( PLAYER_TEXTURE_U_SIZE+g_player.playerTexU, PLAYER_TEXTURE_V_SIZE+g_player.playerTexV );

	}
	if( playerVec == PLAYER_RIGHT ){
	
 		pVtx[3].tex=D3DXVECTOR2( -g_player.playerTexU, -g_player.playerTexV );
		pVtx[2].tex=D3DXVECTOR2( -PLAYER_TEXTURE_U_SIZE-g_player.playerTexU, -g_player.playerTexV );
		pVtx[1].tex=D3DXVECTOR2( -g_player.playerTexU, -PLAYER_TEXTURE_V_SIZE-g_player.playerTexV );
		pVtx[0].tex=D3DXVECTOR2( -PLAYER_TEXTURE_U_SIZE-g_player.playerTexU, -PLAYER_TEXTURE_V_SIZE-g_player.playerTexV );

	}

	// _̍XV
	pVtx[0].pos=D3DXVECTOR3( PLAYER_POS_X + g_player.vec.sx, PLAYER_POS_Y + g_player.vec.sy, 0.0f);
	pVtx[1].pos=D3DXVECTOR3( PLAYER_WIDTH + g_player.vec.sx, PLAYER_POS_Y + g_player.vec.sy, 0.0f);
	pVtx[2].pos=D3DXVECTOR3( PLAYER_POS_X + g_player.vec.sx, PLAYER_HEIGHT + g_player.vec.sy,0.0f);
	pVtx[3].pos=D3DXVECTOR3( PLAYER_WIDTH + g_player.vec.sx, PLAYER_HEIGHT + g_player.vec.sy,0.0f);
	

	// obt@̃AbN
	g_pVtxBufferplayer->Unlock();

	g_player.playerFrame++;

}
// player̕`
void DrawPlayer( void )
{

	LPDIRECT3DDEVICE9 pDevice=nullptr;					//foCX󂯎p֐


	// foCX̎󂯎菈
	pDevice=GetDevice( );

	// Xg[
	pDevice->SetStreamSource(0,							//MS
	g_pVtxBufferplayer,									//ǂ̒_obt@\ƌԂ...
	0,													//f[^̃ItZbg
	sizeof(VERTEX_2D));									//XgChl(oCg)
		
	// _tH[}bg̐ݒ
	pDevice->SetFVF(FVF_VERTEX_2D);

	// eNX`̐ݒ
	pDevice->SetTexture(0,g_pTexturePlayer);				//_UVf[^Zbg
	
	// |S̕`
	pDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,NUM_PLAYER);


}
// player̐FύX֐
void ColorPlayer ( VERTEX_2D *pVtx )
{
	static int i;

	pVtx[0].color=D3DCOLOR_RGBA(255-i,255,255,255);
	pVtx[1].color=D3DCOLOR_RGBA(255,255-i,255,255);
	pVtx[2].color=D3DCOLOR_RGBA(255,255,255-i,255);
	pVtx[3].color=D3DCOLOR_RGBA(255-i,255-i,255-i,255);

	i--;

}
// _̍쐬
HRESULT MakeVertexPlayer( LPDIRECT3DDEVICE9 pDevice )
{

	VERTEX_2D *pVtx;									//zAhX

	if(FAILED(pDevice->CreateVertexBuffer(
			sizeof(VERTEX_2D) * NUM_VERTEX,				//mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,							//gp@
			FVF_VERTEX_2D,								//gp钸_tH[}bg(ȏȂQƂȂ̂0ł悢)
			D3DPOOL_MANAGED,							//obt@̊Ǘ@(obt@̒ɏ񂾂̂̊Ǘ@)
			&g_pVtxBufferplayer,						//i[|C^
			NULL)))
	{

		MessageBox(NULL,"obt@ւ݂̏Ɏs܂!!","vertex buffer ERROR!!",MB_OK);
		return E_FAIL;
	}

	// obt@bNzAhX擾
	g_pVtxBufferplayer -> Lock(0,0,(void**)&pVtx,0);	//GPUVRAMւ̑bN



	// _W̐ݒ

	pVtx[0].pos=D3DXVECTOR3( PLAYER_POS_X, PLAYER_POS_Y, 0.0f);
	pVtx[1].pos=D3DXVECTOR3( PLAYER_WIDTH, PLAYER_POS_Y, 0.0f);
	pVtx[2].pos=D3DXVECTOR3( PLAYER_POS_X, PLAYER_HEIGHT,0.0f);
	pVtx[3].pos=D3DXVECTOR3( PLAYER_WIDTH, PLAYER_HEIGHT,0.0f);

	pVtx[0].rhw=1.0f;
	pVtx[1].rhw=1.0f;
	pVtx[2].rhw=1.0f;
	pVtx[3].rhw=1.0f;

	pVtx[0].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[1].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[2].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[3].color=D3DCOLOR_RGBA(255,255,255,255);

	pVtx[0].tex=D3DXVECTOR2( 0.0f, 0.0f );
	pVtx[1].tex=D3DXVECTOR2( 1.0f, 0.0f );
	pVtx[2].tex=D3DXVECTOR2( 0.0f, 1.0f );
	pVtx[3].tex=D3DXVECTOR2( 1.0f, 1.0f );

	// obt@̃AbN
	g_pVtxBufferplayer->Unlock();

	return S_OK;

}
// W̎擾
VECTOR_2D GetPlayerPos(void)
{

	return (g_player.vec);

}

